/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fun>
#include <fakemeta>
#include <hamsandwich>
#include <engine>

#define PLUGIN "Furien Mod"
#define VERSION "64.2.6b"
#define AUTHOR "Kia"

// ===============================================================================
// 	Variables
// ===============================================================================

/* Defines */

// Sets maximum of items for Furien Shop
#define FURIEN_SHOP_MAX 	8

// Sets maximum of items for CT Shop
#define CT_SHOP_MAX 		9

// Sets maximum of items for CT Gun Meun
#define CT_WEAPON_MAX 		5

// Delay after spawn to give stuff
#define EQUIP_DELAY 		0.1

// Maximum Health
#define MAX_HP 			200

#define TASK_ID_SWAPTEAMS 2000
#define XO_WEAPON 4
#define m_pPlayer 41
#define XO_PLAYER	5
#define m_pActiveItem	373
#define DO_NOT_CHANGE	2

/* Enums */

enum _:ShopItems
{
	ItemName[64], ItemCost[ 64 ], ItemPlugin[64],  ItemFunction[ 64 ], ItemMax[64], ItemReset[64]
}

enum _:GunItems
{
	ItemName[64], ItemPri[64], ItemPriConst[64], ItemSec[64], ItemSecConst[64]
}

/* Entitys */

new TaskEnt

/* Hamsandwich */

new Ham:Ham_Player_ResetMaxSpeed = Ham_Item_PreFrame 

/* Booleans */

new bool:g_bHasAcceptedSettings[33]
new bool:g_bHasWeapon[33]
new bool:g_bWantsLowGrav[33]
new bool:g_bHasSuperKnife[33]
new bool:g_bHasNoFlash[33]

/* Integer */

new g_iMaxPlayers

new g_iItemIndex_T[33][FURIEN_SHOP_MAX]
new g_iItemIndex_CT[33][CT_SHOP_MAX]

new g_iHP[33]

/* CVars */

new cvar_gm, cvar_hpsave

/* CVars - Furien */

new cvar_t_starthe, cvar_t_startflash, cvar_t_startsmoke
new cvar_t_grav, cvar_t_speed, cvar_t_fs
new cvar_t_psf

/* CVars - CTs */

new cvar_ct_starthe, cvar_ct_startflash, cvar_ct_startsmoke
new cvar_ct_grav, cvar_ct_fs
new cvar_ct_ammo_pri, cvar_ct_ammo_sec

/* Constants - Shop */

new const g_mFurienItems[FURIEN_SHOP_MAX][ShopItems] = {
	{"Superknife", 		16000, 	"CORE", 		"shop_t_givesk", 	1,	DO_NOT_CHANGE}, // "Itemname", COST, "CORE / Pluginname", "Function", "Maximum", "Reset
	{"Deagle (14 Gojoval)", 10000,  "CORE", 			"shop_t_givedgl",	1,	2}, // 0 : No Reset ; 1 : Round Reset ; 2 : Death Reset
	{"50 HP", 		4000, 	"CORE", 		"shop_t_givehp",	2,	1},
	{"75 AP",		2000,	"CORE", 		"shop_t_giveap",	2,	1},
	{"1 HE Granat",	1000,	"CORE", 		"shop_givehe",		2,	1},
	{"1 Vakito Granat",	1000,	"CORE", 		"shop_giveflash",	2,	1},
	{"1 Fust Granat",	1000,	"CORE", 		"shop_givesmoke",	1,	1},
	{"Nincs vakulas",		500,	"CORE", 		"shop_givenf",		1,	DO_NOT_CHANGE}
}

new const g_mCTItems[CT_SHOP_MAX][ShopItems] = {
	{"Defuse Kit",		300,	"CORE", 			"shop_ct_givedefkit",		1,	2},
	{"Para (200 Gojoval)",	16000,	"CORE", 			"shop_ct_givepara",		1,	1},
	{"50 HP",		4000,	"CORE", 			"shop_ct_givehp",		2,	1},
	{"75 AP",		3500,	"CORE", 			"shop_ct_giveap",		1,	1},
	{"1 HE Granat",		2000,	"CORE", 			"shop_givehe",			1,	1},
	{"1 Vakito Granat",	1000,	"CORE", 			"shop_giveflash",		1,	1},
	{"1 Fust Granat",	1000,	"CORE", 			"shop_givesmoke",		1,	1},
	{"Nincs vakulas",	4000,	"CORE", 			"shop_givenf",			1,	DO_NOT_CHANGE},
	{"Superdeagle",		16000,	"kfm_extra_sdgl.amxx", 		"zp_extra_item_selected",	1,	1}
}

/* Constants - Weapons */

new const g_mCTWeapons[CT_WEAPON_MAX][GunItems] = {
	{"AK47 + Deagle", 	"weapon_ak47",		CSW_AK47,		"weapon_deagle",	CSW_DEAGLE},
	{"M4A1 + Deagle", 	"weapon_m4a1", 		CSW_M4A1,		"weapon_deagle",	CSW_DEAGLE},
	{"Famas + Deagle", 	"weapon_famas", 	CSW_FAMAS,		"weapon_deagle",	CSW_DEAGLE},
	{"MP5 + Deagle", 	"weapon_mp5navy", 	CSW_MP5NAVY, 		"weapon_deagle",	CSW_DEAGLE},
	{"XM1014 + Deagle", 	"weapon_xm1014", 	CSW_XM1014,		"weapon_deagle",	CSW_DEAGLE}
}
	
	
/* Constants */

const SWAP_PER_INTERVAL = 5
const Float:SWAP_INTERVAL = 0.5

const fPainShock = 108

new const models[][] =
{
	"models/w_backpack.mdl",
	"models/w_flashbang.mdl",
	"models/w_hegrenade.mdl",
	"models/w_smokegrenade.mdl"
}

/* Misc */

new g_msgScreenFade

/* PreCache */

new const sz_SuperKnife_V_Model[] = "models/kfm/v_superknife.mdl"

// ===============================================================================
// 	plugin_precache - Files that will be downloaded
// ===============================================================================

public plugin_precache()
{
	precache_model(sz_SuperKnife_V_Model)
}
// ===============================================================================
// 	plugin_init - Do not modify this unless you know what you're doing
// ===============================================================================

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	/* CVars */
	
	register_cvar("kias_furien", VERSION, FCVAR_SERVER | FCVAR_SPONLY | FCVAR_EXTDLL)
	cvar_gm			= register_cvar("kfm_godend",		"1")
	cvar_hpsave		= register_cvar("kfm_savehp",		"1")
	
	/* CVars - Furien */
	
	cvar_t_starthe		= register_cvar("kfm_t_starthe", 	"1")
	cvar_t_startflash	= register_cvar("kfm_t_startflash", 	"2")
	cvar_t_startsmoke 	= register_cvar("kfm_t_startsmoke", 	"1")
	
	cvar_t_grav		= register_cvar("kfm_t_grav",		"0.39")
	cvar_t_speed		= register_cvar("kfm_t_speed",		"565")
	cvar_t_fs		= register_cvar("kfm_t_fs",		"1")
	
	cvar_t_psf		= register_cvar("kfm_t_psf",		"1")

	/* CVars - CTs */
	
	cvar_ct_starthe		= register_cvar("kfm_ct_starthe", 	"0")
	cvar_ct_startflash	= register_cvar("kfm_ct_startflash", 	"0")
	cvar_ct_startsmoke 	= register_cvar("kfm_ct_startsmoke", 	"1")
	
	cvar_ct_grav		= register_cvar("kfm_ct_grav",		"1.0")
	cvar_ct_fs		= register_cvar("kfm_ct_fs",		"0")
	
	cvar_ct_ammo_pri	= register_cvar("kfm_ct_ammo_primary",	"200")
	cvar_ct_ammo_sec	= register_cvar("kfm_ct_ammo_secondary", "150")
	
	/* Commands */
	
	register_clcmd("say /guns", 		"cmd_Guns")
	register_clcmd("say_team /guns", 	"cmd_Guns")
	register_clcmd("say guns", 		"cmd_Guns")
	register_clcmd("say_team guns", 	"cmd_Guns")
	register_clcmd("guns",			"cmd_Guns")
	
	register_clcmd("say /gravity", 		"cmd_Gravity")
	register_clcmd("say_team /gravity", 	"cmd_Gravity")
	register_clcmd("say gravity", 		"cmd_Gravity")
	register_clcmd("say_team gravity", 	"cmd_Gravity")
	register_clcmd("gravity",		"cmd_Gravity")
	
	register_clcmd("say /shop", 		"cmd_Shop")
	register_clcmd("say_team /shop", 	"cmd_Shop")
	register_clcmd("say shop", 		"cmd_Shop")
	register_clcmd("say_team shop", 	"cmd_Shop")
	register_clcmd("shop",			"cmd_Shop")
	
	/* Events */
	
	register_event("SendAudio", "Event_CTWin", "a", "2&%!MRAD_ctwin" ) 
	register_event("CurWeapon", "Event_CurWeapon", "be", "1=1")
	register_event("ScreenFade", "Event_Flashed", "be", "4=255", "5=255", "6=255", "7>199")
	register_event("DeathMsg", "Event_DeathMsg", "a")
	register_event("WeapPickup", "Event_WeaponPickup", "b")
	
	/* Logevents */
	
	register_logevent("LogEvent_RoundEnd", 2, "1=Round_End")  
	
	/* Hamsandwich */
	
	RegisterHam(Ham_Spawn, "player", "func_HamSpawn", 1)
	RegisterHam(Ham_TakeDamage, "player", "func_TakeDamage")
	RegisterHam(Ham_Item_Deploy, "weapon_knife", "func_HamTookKnife", true)
	
	/* Forwards */
	
	register_forward(FM_Think, "fw_Think")
	register_forward(FM_Touch, "fw_Touch")
	
	/* Misc */
	
	TaskEnt = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))	
	set_pev(TaskEnt, pev_classname, "speedometer_think")
	set_pev(TaskEnt, pev_nextthink, get_gametime() + 1.01)
	
	g_msgScreenFade = get_user_msgid("ScreenFade")
	g_iMaxPlayers = get_maxplayers()
}

// ===============================================================================
// 	Client Connect
// ===============================================================================

public client_putinserver(id)
{
	g_bHasAcceptedSettings[id] = false
	g_bHasWeapon[id] = false
	g_bHasSuperKnife[id] = false
	g_bHasNoFlash[id] = false
	g_bWantsLowGrav[id] = true
	
	g_iItemIndex_CT[id][0] = false
	g_iItemIndex_T[id][0] = false
	g_iHP[id] = 100
}

// ===============================================================================
// 	Client Disconnect
// ===============================================================================

public client_disconnect(id)
{
	g_bHasAcceptedSettings[id] = false
	g_bHasWeapon[id] = false
	g_bHasSuperKnife[id] = false
	g_bHasNoFlash[id] = false
	g_bWantsLowGrav[id] = true
	
	g_iItemIndex_CT[id][0] = false
	g_iItemIndex_T[id][0] = false
	g_iHP[id] = 100
}

// ===============================================================================
// 	say /guns
// ===============================================================================

public cmd_Guns(id)
{
	if(is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT && !g_bHasWeapon[id])
		func_OpenGunMenu(id)
}

// ===============================================================================
// 	say /gravity
// ===============================================================================

public cmd_Gravity(id)
{
	g_bWantsLowGrav[id] = g_bWantsLowGrav[id] ? false : true
	client_print(id, print_chat, "[%s] Low-Gravity is now %s.", PLUGIN, g_bWantsLowGrav[id] == true ? "enabled" : "disabled")
	
	if(cs_get_user_team(id) == CS_TEAM_T)
		set_user_gravity(id, g_bWantsLowGrav[id] ? get_pcvar_float(cvar_t_grav) : 1.0)
}

// ===============================================================================
// 	say /shop
// ===============================================================================

public cmd_Shop(id)
{
	if(!is_user_alive(id))
		return PLUGIN_HANDLED
		
	switch(cs_get_user_team(id))
	{
		case CS_TEAM_T  : func_OpenTShop(id)
		case CS_TEAM_CT : func_OpenCTShop(id)
	}
	
	return PLUGIN_HANDLED
}

// ===============================================================================
// 	func_OpenTShop - Shop for Ts
// ===============================================================================

public func_OpenTShop(id)
{
	
	static szMenuTitle[128]
	new szItemTitle[128]
	new iAccess
	
	formatex(szMenuTitle, charsmax(szMenuTitle), "Furien V64 - Furien Bolt")
	
	new menu = menu_create(szMenuTitle, "func_OpenTShop_handler")
	
	for( new i = 0; i < sizeof(g_mFurienItems); i++ ) 
	{
		formatex(szItemTitle, charsmax(szItemTitle), "%s - \y$%i", g_mFurienItems[i][ItemName], g_mFurienItems[i][ItemCost])
		
		if(cs_get_user_money(id) >= g_mFurienItems[i][ItemCost] && g_iItemIndex_T[id][i] < g_mFurienItems[i][ItemMax] )
			iAccess = 0
		else
			iAccess = 1<<31
				
		menu_additem(menu, szItemTitle, _, iAccess)
	}
		
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public func_OpenTShop_handler(id, menu, item)
{
	if( item == MENU_EXIT || cs_get_user_team(id) != CS_TEAM_T || !is_user_alive(id)) 
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	new szPlugin[64]
	
	if(equali(g_mFurienItems[item][ItemPlugin], "CORE"))
		formatex(szPlugin, charsmax(szPlugin), "")
	else
		formatex(szPlugin, charsmax(szPlugin), g_mFurienItems[item][ItemPlugin])
	
	if( callfunc_begin(g_mFurienItems[item][ItemFunction], szPlugin) == 1 ) 
	{
		callfunc_push_int(id)
		callfunc_end()
			
		Reduce(id, g_mFurienItems[item][ItemCost])			
		g_iItemIndex_T[id][item]++
	}
	
	
	return PLUGIN_HANDLED
}

// ===============================================================================
// 	Item Handlers for Furien Shop
// ===============================================================================

public shop_t_givesk(id)
{
	g_bHasSuperKnife[id] = true
	engclient_cmd(id, "weapon_knife")
	ExecuteHamB(Ham_Item_Deploy, get_pdata_cbase(id, m_pActiveItem, XO_PLAYER))
}

public shop_t_givedgl(id)
{
	give_item(id, "weapon_deagle")
	cs_set_user_bpammo(id, CSW_DEAGLE, 7)
	engclient_cmd(id, "weapon_deagle")
}

public shop_t_givehp(id)
{
	set_user_health(id, min(get_user_health(id) + 50, MAX_HP))  
}

public shop_t_giveap(id)
	set_user_armor(id, get_user_armor(id) + 75)

// ===============================================================================
// 	General Item Handlers
// ===============================================================================


public shop_givehe(id)
{
	if(cs_get_user_bpammo(id, CSW_HEGRENADE) < 1)
	{
		give_item(id, "weapon_hegrenade")
		return PLUGIN_HANDLED
	}
	
	cs_set_user_bpammo(id,CSW_HEGRENADE, cs_get_user_bpammo(id, CSW_HEGRENADE) + 1)
	return PLUGIN_HANDLED
}

public shop_giveflash(id)
{
	if(cs_get_user_bpammo(id, CSW_FLASHBANG) < 1)
	{
		give_item(id, "weapon_flashbang")
		return PLUGIN_HANDLED
	}
	
	cs_set_user_bpammo(id,CSW_FLASHBANG, cs_get_user_bpammo(id, CSW_FLASHBANG) + 1)	
	return PLUGIN_HANDLED
}

public shop_givesmoke(id)
{
	if(cs_get_user_bpammo(id, CSW_SMOKEGRENADE) < 1)
	{
		give_item(id, "weapon_smokegrenade")
		return PLUGIN_HANDLED
	}
	
	cs_set_user_bpammo(id,CSW_SMOKEGRENADE, cs_get_user_bpammo(id, CSW_SMOKEGRENADE) + 1)	
	return PLUGIN_HANDLED
}
	
public shop_givenf(id)
	g_bHasNoFlash[id] = true

// ===============================================================================
// 	func_OpenCTShop - Shop for CTs
// ===============================================================================

public func_OpenCTShop(id)
{
	if(!is_user_alive(id))
		return PLUGIN_HANDLED
	
	static szMenuTitle[64]
	new szItemTitle[64]
	new iAccess
	
	formatex(szMenuTitle, charsmax(szMenuTitle), "Furien V64 - Anti-Furien Bolt")
	
	new menu = menu_create(szMenuTitle, "func_OpenCTShop_handler")
	
	for( new i = 0; i < sizeof(g_mCTItems); i++ ) 
	{
		formatex(szItemTitle, charsmax(szItemTitle), "%s - \y$%i", g_mCTItems[i][ItemName], g_mCTItems[i][ItemCost])
		
		if(cs_get_user_money(id) >= g_mCTItems[i][ItemCost] && g_iItemIndex_CT[id][i] < g_mCTItems[i][ItemMax] )
			iAccess = 0
		else
			iAccess = 1<<31

		menu_additem(menu, szItemTitle, _, iAccess)
	}
		
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public func_OpenCTShop_handler(id, menu, item)
{
	if( item == MENU_EXIT ||  cs_get_user_team(id) != CS_TEAM_CT || !is_user_alive(id) ) 
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	new szPlugin[64]
	
	if(equali(g_mCTItems[item][ItemPlugin], "CORE"))
		formatex(szPlugin, charsmax(szPlugin), "")
	else
		formatex(szPlugin, charsmax(szPlugin), g_mCTItems[item][ItemPlugin])
	
	if( callfunc_begin(g_mCTItems[item][ItemFunction], szPlugin) == 1 ) 
	{
		callfunc_push_int(id)
		callfunc_end()
		
		Reduce(id, g_mCTItems[item][ItemCost])
		g_iItemIndex_CT[id][item]++
	}
	
	return PLUGIN_HANDLED
}

// ===============================================================================
// 	Item Handlers for CT Shop
// ===============================================================================

public shop_ct_givedefkit(id)
	cs_set_user_defuse(id, 1)

public shop_ct_givepara(id)
{
	give_item(id, "weapon_m249")
	cs_set_user_bpammo(id, CSW_M249, 100)
}

public shop_ct_givehp(id)
	set_user_health(id, min(get_user_health(id) + 50, MAX_HP))  

public shop_ct_giveap(id)
	set_user_armor(id, get_user_armor(id) + 75)


// ===============================================================================
// 	func_OpenGunMenu - Gun Menu for CTs
// ===============================================================================

public func_OpenGunMenu(id)
{
	if(!is_user_alive(id))
		return PLUGIN_HANDLED
	
	static szMenuTitle[128]
	new szItemTitle[128]

	formatex(szMenuTitle, charsmax(szMenuTitle), "Furien V64 - Gun Menu")
	
	new menu = menu_create(szMenuTitle, "func_OpenGunMenu_handler")
	
	for( new i = 0; i < sizeof(g_mCTWeapons); i++ ) 
	{
		formatex(szItemTitle, charsmax(szItemTitle), "%s", g_mCTWeapons[i][ItemName])
				
		menu_additem(menu, szItemTitle, _, 0)
	}
		
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public func_OpenGunMenu_handler(id, menu, item)
{
	if(cs_get_user_team(id) != CS_TEAM_CT || !is_user_alive(id))
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	give_item(id, g_mCTWeapons[item][ItemPri])
	cs_set_user_bpammo(id, g_mCTWeapons[item][ItemPriConst], get_pcvar_num(cvar_ct_ammo_pri))
	
	give_item(id, g_mCTWeapons[item][ItemSec])
	cs_set_user_bpammo(id, g_mCTWeapons[item][ItemSecConst], get_pcvar_num(cvar_ct_ammo_sec))
	
	g_bHasWeapon[id] = true
	return PLUGIN_HANDLED
}

// ===============================================================================
// 	Event - @ CT Win - Credits go to Exolent
// ===============================================================================

public Event_CTWin()
{
	static iCount, client;
	
	iCount = 0;
	
	for( client = 0; client <= g_iMaxPlayers; client++ )
	{
		if( is_user_connected( client ) )
		{
			if( iCount >= SWAP_PER_INTERVAL )
			{
				set_task( SWAP_INTERVAL, "Event_CTWin", TASK_ID_SWAPTEAMS );
			}
			
			switch( cs_get_user_team( client ) )
			{
				case CS_TEAM_T:
				{
					cs_set_user_team( client, CS_TEAM_CT, CS_CT_GIGN );
					
					iCount++;
				}
				case CS_TEAM_CT:
				{
					cs_set_user_team( client, CS_TEAM_T, CS_T_LEET );
					
					iCount++;
				}
			}
		}
	}
	
	remove_task(TASK_ID_SWAPTEAMS)
}

// ===============================================================================
// 	Event - CurWeapon
// ===============================================================================

public Event_CurWeapon(id)
{
	if(is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_T)
		set_user_maxspeed(id, get_pcvar_float(cvar_t_speed))
}

// ===============================================================================
// 	Event - Flashed
// ===============================================================================

public Event_Flashed(id)
{
	if(g_bHasNoFlash[id])
	{
		message_begin(MSG_ONE, g_msgScreenFade, {0,0,0},id)
		write_short(1)
		write_short(1)
		write_short(1)
		write_byte(0)
		write_byte(0)
		write_byte(0)
		write_byte(255)
		message_end()
	}
	
}

// ===============================================================================
// 	Event - DeathMsg
// ===============================================================================

public Event_DeathMsg(id)
{
	new iVictim = read_data(2)
	
	for( new i = 0; i < sizeof(g_mCTItems); i++ ) 
	{
		if(g_mCTItems[i][ItemReset] == 2)
			g_iItemIndex_CT[iVictim][i] = 0
	}
		
	for( new i = 0; i < sizeof(g_mFurienItems); i++ ) 
	{
		if(g_mFurienItems[i][ItemReset] == 2)
		{
			g_iItemIndex_T[iVictim][i] = 0
		}
	}
	
	g_bHasSuperKnife[iVictim] = false
	g_bHasNoFlash[iVictim] = false
}

// ===============================================================================
// 	Event - Weapon Pickup
// ===============================================================================

public Event_WeaponPickup(id, weapon)
{
	if(cs_get_user_team(id) == CS_TEAM_T && get_user_weapon(id) == CSW_C4)
	{
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

// ===============================================================================
// 	LogEvent - Round End
// ===============================================================================

public LogEvent_RoundEnd()
{
	new players[32], pnum, tempid
	get_players(players, pnum, "a")
	
	for( new i; i<pnum; i++ ) 
	{
		tempid = players[i]
		
		if(get_pcvar_num(cvar_hpsave) && get_user_health(tempid) > 100)
			g_iHP[tempid] = get_user_health(tempid)
		
		strip_user_weapons(tempid)
		give_item(tempid, "weapon_knife")
		
		if(get_pcvar_num(cvar_gm))
			set_user_godmode(tempid, 1)
	}
}		

// ===============================================================================
// 	Hamsandwich - Ham_Spawn
// ===============================================================================

public func_HamSpawn(id)
{
	if(is_user_alive(id))
	{
		for( new i = 0; i < sizeof(g_mCTItems); i++ ) 
		{
			if(g_mCTItems[i][ItemReset] == 1)
			{
				g_iItemIndex_CT[id][i] = 0
			}
		}
		
		for( new i = 0; i < sizeof(g_mFurienItems); i++ ) 
		{
			if(g_mFurienItems[i][ItemReset] == 1)
			{
				g_iItemIndex_T[id][i] = 0
			}
		}
		
		if(get_pcvar_num(cvar_hpsave))
		{
			if(g_iHP[id] < 100)
				g_iHP[id] = 100
				
			set_user_health(id, g_iHP[id])
			g_iHP[id] = 100
		}
		
		set_user_godmode(id, 0)
		strip_user_weapons(id)
		give_item(id, "weapon_knife")
		
		if(g_bHasAcceptedSettings[id])
		{
			func_ApplyGameplay(id)
		}
		else
		{
			func_AskForPermission(id)
		}
	}
}

// ===============================================================================
// 	Hamsandwich - Take_Damage - Credits go to ConnorMcLeod
// ===============================================================================

public func_TakeDamage(victim, inflictor, attacker, Float:damage, damage_type)
{
	if (inflictor == attacker && is_user_alive(attacker) && get_user_weapon(attacker) == CSW_KNIFE && g_bHasSuperKnife[attacker])
	{
		SetHamParamFloat(4, damage * 3)
	}
	
	if(get_pcvar_num(cvar_t_psf) && cs_get_user_team(victim) == CS_TEAM_T)
		set_pdata_float(victim, fPainShock, 1.0, 5)
}

// ===============================================================================
// 	Hamsandiwch - Item_Deploy - Credits go to ConnorMcLeod
// ===============================================================================

public func_HamTookKnife(iKnife)
{
	new id = get_pdata_cbase(iKnife, m_pPlayer, XO_WEAPON)
	
	if(g_bHasSuperKnife[id])
	{
		entity_set_string( id, EV_SZ_viewmodel, sz_SuperKnife_V_Model)
	}
}

// ===============================================================================
// 	Forwards - FM_Think - Credits go to ConnorMcLeod
// ===============================================================================

public fw_Think(ent)
{
	if(ent == TaskEnt) 
	{
		SpeedTask()
		set_pev(ent, pev_nextthink,  get_gametime() + 0.1)
	}
}

public SpeedTask()
{
	static i, target
	static Float:velocity[3]
	static Float:speed

	for(i = 1; i <= g_iMaxPlayers ; i++)
	{
		if(!is_user_connected(i)) continue
	
		target = pev(i, pev_iuser1) == 4 ? pev(i, pev_iuser2) : i
		pev(target, pev_velocity, velocity)
	
		speed = vector_length(velocity)
		if(speed < 5 && get_user_weapon(i) == CSW_KNIFE && get_user_team(i) == 1)
		{
		 	set_user_rendering(i,kRenderFxNone,0,0,0,kRenderTransAlpha,0)  
		}
		else if(speed > 5)
		{
			set_user_rendering(i,kRenderFxNone,0,0,0,kRenderTransAlpha,255)  
		}
	}
}

// ===============================================================================
// 	Forwards - FM_Touch
// ===============================================================================

public fw_Touch( ent , id )
{
	if (!(1 <= id <= g_iMaxPlayers) || get_user_team(id) == 2 || !pev_valid(ent) || !(pev(ent , pev_flags) & FL_ONGROUND))
		return FMRES_IGNORED;
	
	static szEntModel[32];
	pev(ent , pev_model , szEntModel , 31);
	
	return equal(szEntModel , models[random(sizeof(models))]) ? FMRES_IGNORED : FMRES_SUPERCEDE;
}

// ===============================================================================
// 	func_ApplyGameplay - Getting Players Team and selecting function
// ===============================================================================

public func_ApplyGameplay(id)
{
	switch(cs_get_user_team(id))
	{
		case CS_TEAM_CT : set_task(EQUIP_DELAY, "func_CTEquip", id)
		case CS_TEAM_T : set_task(EQUIP_DELAY, "func_TEquip", id)
	}
}

// ===============================================================================
// 	func_CTEquip - Giving Equipment for CTs
// ===============================================================================

public func_CTEquip(id)
{
	if(get_pcvar_num(cvar_ct_starthe) > 0)
	{
		give_item(id, "weapon_hegrenade")
		if(get_pcvar_num(cvar_ct_starthe) > 1)
		{
			cs_set_user_bpammo(id, CSW_HEGRENADE, get_pcvar_num(cvar_ct_starthe))
		}
	}
	
	if(get_pcvar_num(cvar_ct_startflash) > 0)
	{
		give_item(id, "weapon_flashbang")
		if(get_pcvar_num(cvar_ct_startflash) > 1)
		{
			cs_set_user_bpammo(id, CSW_FLASHBANG, get_pcvar_num(cvar_ct_startflash))
		}
	}
	
	if(get_pcvar_num(cvar_ct_startsmoke) > 0)
	{
		give_item(id, "weapon_smokegrenade")
		if(get_pcvar_num(cvar_ct_startsmoke) > 1)
		{
			cs_set_user_bpammo(id, CSW_SMOKEGRENADE, get_pcvar_num(cvar_ct_startsmoke))
		}
	}
	
	set_user_gravity(id, get_pcvar_float(cvar_ct_grav))
	set_user_footsteps(id, get_pcvar_num(cvar_ct_fs))
	ExecuteHamB(Ham_Player_ResetMaxSpeed, id)
	func_OpenGunMenu(id)
}

// ===============================================================================
// 	func_TEquip - Giving Equipment for Ts
// ===============================================================================

public func_TEquip(id)
{
	if(get_pcvar_num(cvar_t_starthe) > 0)
	{
		give_item(id, "weapon_hegrenade")
		if(get_pcvar_num(cvar_t_starthe) > 1)
		{
			cs_set_user_bpammo(id, CSW_HEGRENADE, get_pcvar_num(cvar_t_starthe))
		}
	}
	
	if(get_pcvar_num(cvar_t_startflash) > 0)
	{
		give_item(id, "weapon_flashbang")
		if(get_pcvar_num(cvar_t_startflash) > 1)
		{
			cs_set_user_bpammo(id, CSW_FLASHBANG, get_pcvar_num(cvar_t_startflash))
		}
	}
	
	if(get_pcvar_num(cvar_t_startsmoke) > 0)
	{
		give_item(id, "weapon_smokegrenade")
		if(get_pcvar_num(cvar_t_startsmoke) > 1)
		{
			cs_set_user_bpammo(id, CSW_SMOKEGRENADE, get_pcvar_num(cvar_t_startsmoke))
		}
	}
	
	if(g_bWantsLowGrav[id])
		set_user_gravity(id, get_pcvar_float(cvar_t_grav))
	
	set_user_footsteps(id, get_pcvar_num(cvar_t_fs))
	set_user_maxspeed(id, get_pcvar_float(cvar_t_speed))
}
	
// ===============================================================================
// 	func_AskForPermission - Asking player to set cl_ values.
// ===============================================================================

public func_AskForPermission(id)
{
	new szMenuTitle[128]
	formatex(szMenuTitle, charsmax(szMenuTitle), "\wSzukseges a modhoz az elore es hatra sebesseged megvaltoztatasa engedelyezed?")
	new menu = menu_create(szMenuTitle, "func_AskForPermission_handler")
	
	menu_additem(menu, "\wIgen","1",0);
	menu_additem(menu, "\rNem (Lassabban futsz mint a tobbiek)","2",0);
	
	menu_display(id, menu, 0);
	return PLUGIN_HANDLED
}

public func_AskForPermission_handler(id, menu, item)
{
	new data[6], szName[64];
	new access, callback;
	menu_item_getinfo(menu, item, access, data,charsmax(data), szName,charsmax(szName), callback);
	new key = str_to_num(data);
	
	switch(key)
	{
		case 1:
		{
			g_bHasAcceptedSettings[id] = true
			
			client_cmd(id, "cl_forwardspeed %i",get_pcvar_num(cvar_t_speed))
			client_cmd(id, "cl_sidespeed %i",get_pcvar_num(cvar_t_speed))
			client_cmd(id, "cl_backspeed %i",get_pcvar_num(cvar_t_speed))
			
			if(is_user_alive(id))
				func_ApplyGameplay(id)
		}
		case 2:
		{
			g_bHasAcceptedSettings[id] = false
		}
	}
}

// ===============================================================================
// 	Stocks
// ===============================================================================

stock Reduce(id, amount)
	cs_set_user_money(id, cs_get_user_money(id) - amount)
